/*
 * Decompiled with CFR 0.152.
 */
package com.byteowls.jopencage.model;

import com.byteowls.jopencage.model.JOpenCageBounds;
import com.byteowls.jopencage.model.JOpenCageLatLng;
import com.byteowls.jopencage.model.JOpenCageRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JOpenCageForwardRequest
extends JOpenCageRequest {
    private JOpenCageBounds bounds;
    private String restrictToCountryCode;
    private List<String> queryParts = new ArrayList<String>();
    private String queryPartSeparator = ",";

    public JOpenCageForwardRequest(String query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must not null!");
        }
        this.queryParts.add(query);
    }

    public JOpenCageForwardRequest(String ... queryParts) {
        if (queryParts == null || queryParts.length <= 0) {
            throw new IllegalArgumentException("queryParts must not null!");
        }
        for (String p : queryParts) {
            this.queryParts.add(p);
        }
    }

    @Override
    public Map<String, String> getParameter() {
        Map<String, String> parameter = super.getParameter();
        StringBuilder sb = new StringBuilder();
        for (String p : this.queryParts) {
            if (p == null) continue;
            if (sb.length() > 0) {
                sb.append(this.queryPartSeparator);
            }
            sb.append(p);
        }
        parameter.put("q", sb.toString());
        if (this.bounds != null) {
            String boundsSTr = this.bounds.getSouthwest().getLat() + "," + this.bounds.getSouthwest().getLng() + "," + this.bounds.getNortheast().getLat() + "," + this.bounds.getNortheast().getLng();
            parameter.put("bounds", boundsSTr);
        }
        parameter.put("countrycode", this.restrictToCountryCode);
        return parameter;
    }

    public JOpenCageBounds getBounds() {
        return this.bounds;
    }

    public void setBounds(JOpenCageBounds bounds) {
        this.bounds = bounds;
    }

    public void setBounds(Double northEastLat, Double northEastLng, Double southWestLat, Double southWestLng) {
        this.bounds = new JOpenCageBounds();
        JOpenCageLatLng ne = new JOpenCageLatLng();
        ne.setLat(northEastLat);
        ne.setLng(northEastLng);
        this.bounds.setNortheast(ne);
        JOpenCageLatLng sw = new JOpenCageLatLng();
        sw.setLat(southWestLat);
        sw.setLng(southWestLng);
        this.bounds.setSouthwest(sw);
    }

    public String getRestrictToCountryCode() {
        return this.restrictToCountryCode;
    }

    public void setRestrictToCountryCode(String restrictToCountryCode) {
        this.restrictToCountryCode = restrictToCountryCode;
    }

    public void setQueryPartSeparator(String queryPartSeparator) {
        this.queryPartSeparator = queryPartSeparator;
    }
}

